// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     content/common/service_port_service.mojom
//

package org.chromium.mojom.content;

class ServicePortDispatcher_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ServicePortDispatcher, ServicePortDispatcher.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ServicePortDispatcher, ServicePortDispatcher.Proxy>() {
    
        public String getName() {
            return "content::ServicePortDispatcher";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ServicePortDispatcher impl) {
            return new Stub(core, impl);
        }
    
        public ServicePortDispatcher[] buildArray(int size) {
          return new ServicePortDispatcher[size];
        }
    };

    private static final int CONNECT_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ServicePortDispatcher.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void connect(String targetUrl, String origin, int portId, ConnectResponse callback) {
            ServicePortDispatcherConnectParams _message = new ServicePortDispatcherConnectParams();
            _message.targetUrl = targetUrl;
            _message.origin = origin;
            _message.portId = portId;
            getProxyHandler().getMessageReceiver().acceptWithResponder(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG,
                                    0)),
                    new ServicePortDispatcherConnectResponseParamsForwardToCallback(callback));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ServicePortDispatcher> {

        Stub(org.chromium.mojo.system.Core core, ServicePortDispatcher impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ServicePortDispatcher_Internal.MANAGER, messageWithHeader);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ServicePortDispatcher_Internal.MANAGER, messageWithHeader, receiver);
                    case CONNECT_ORDINAL: {
                        ServicePortDispatcherConnectParams data =
                                ServicePortDispatcherConnectParams.deserialize(messageWithHeader.getPayload());
                        getImpl().connect(data.targetUrl, data.origin, data.portId, new ServicePortDispatcherConnectResponseParamsProxyToResponder(getCore(), receiver, header.getRequestId()));
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ServicePortDispatcherConnectParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String targetUrl;
        public String origin;
        public int portId;
    
        private ServicePortDispatcherConnectParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortDispatcherConnectParams() {
            this(0);
        }
    
        public static ServicePortDispatcherConnectParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortDispatcherConnectParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortDispatcherConnectParams result = new ServicePortDispatcherConnectParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.targetUrl = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.origin = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.portId = decoder0.readInt(24);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(targetUrl, 8, false);
            encoder0.encode(origin, 16, false);
            encoder0.encode(portId, 24);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortDispatcherConnectParams other = (ServicePortDispatcherConnectParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.targetUrl, other.targetUrl))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.origin, other.origin))
                return false;
            if (this.portId != other.portId)
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(targetUrl);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(origin);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(portId);
            return result;
        }
    }

    static final class ServicePortDispatcherConnectResponseParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public int result;
        public String name;
        public String data;
    
        private ServicePortDispatcherConnectResponseParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ServicePortDispatcherConnectResponseParams() {
            this(0);
        }
    
        public static ServicePortDispatcherConnectResponseParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ServicePortDispatcherConnectResponseParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ServicePortDispatcherConnectResponseParams result = new ServicePortDispatcherConnectResponseParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.result = decoder0.readInt(8);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.name = decoder0.readString(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.data = decoder0.readString(24, false);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(result, 8);
            encoder0.encode(name, 16, false);
            encoder0.encode(data, 24, false);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ServicePortDispatcherConnectResponseParams other = (ServicePortDispatcherConnectResponseParams) object;
            if (this.result != other.result)
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.name, other.name))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.data, other.data))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(result);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(name);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(data);
            return result;
        }
    }

    static class ServicePortDispatcherConnectResponseParamsForwardToCallback extends org.chromium.mojo.bindings.SideEffectFreeCloseable
            implements org.chromium.mojo.bindings.MessageReceiver {
        private final ServicePortDispatcher.ConnectResponse mCallback;

        ServicePortDispatcherConnectResponseParamsForwardToCallback(ServicePortDispatcher.ConnectResponse callback) {
            this.mCallback = callback;
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(CONNECT_ORDINAL,
                                           org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG)) {
                    return false;
                }
                ServicePortDispatcherConnectResponseParams response = ServicePortDispatcherConnectResponseParams.deserialize(messageWithHeader.getPayload());
                mCallback.call(response.result, response.name, response.data);
                return true;
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                return false;
            }
        }
    }

    static class ServicePortDispatcherConnectResponseParamsProxyToResponder implements ServicePortDispatcher.ConnectResponse {

        private final org.chromium.mojo.system.Core mCore;
        private final org.chromium.mojo.bindings.MessageReceiver mMessageReceiver;
        private final long mRequestId;

        ServicePortDispatcherConnectResponseParamsProxyToResponder(
                org.chromium.mojo.system.Core core,
                org.chromium.mojo.bindings.MessageReceiver messageReceiver,
                long requestId) {
            mCore = core;
            mMessageReceiver = messageReceiver;
            mRequestId = requestId;
        }

        @Override
        public void call(Integer result, String name, String data) {
            ServicePortDispatcherConnectResponseParams _response = new ServicePortDispatcherConnectResponseParams();
            _response.result = result;
            _response.name = name;
            _response.data = data;
            org.chromium.mojo.bindings.ServiceMessage _message =
                    _response.serializeWithHeader(
                            mCore,
                            new org.chromium.mojo.bindings.MessageHeader(
                                    CONNECT_ORDINAL,
                                    org.chromium.mojo.bindings.MessageHeader.MESSAGE_IS_RESPONSE_FLAG,
                                    mRequestId));
            mMessageReceiver.accept(_message);
        }
    }

}

